#include <bits/stdc++.h>
using namespace std;

static inline void set_bit(uint64_t* arr, int blocks, int i, int s) {
    int b = s >> 6;          // /64
    int off = s & 63;        // %64
    arr[(long long)i * blocks + b] |= (1ULL << off);
}

static inline bool get_bit(const uint64_t* arr, int blocks, int i, int s) {
    int b = s >> 6;
    int off = s & 63;
    return (arr[(long long)i * blocks + b] >> off) & 1ULL;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<long long> w(N+1), v(N+1);
    long long vmax = 0;
    for (int i = 1; i <= N; i++) {
        cin >> w[i] >> v[i];
        vmax = max(vmax, v[i]);
    }

    if (N == 0 || W <= 0 || vmax == 0) {
        cout << 0 << "\n\n";
        return 0;
    }

    // FPTAS scaling: K = eps * vmax / N
    long double K = (long double)eps * (long double)vmax / (long double)N;
    if (K <= 0) K = 1;

    vector<int> vp(N+1);
    long long sumVp = 0;
    for (int i = 1; i <= N; i++) {
        vp[i] = (int)floor((long double)v[i] / K);
        if (vp[i] < 0) vp[i] = 0;
        sumVp += vp[i];
    }

    // If everything scaled to 0, just take best single item that fits.
    if (sumVp == 0) {
        long long bestV = 0;
        int bestI = -1;
        for (int i = 1; i <= N; i++) {
            if (w[i] <= W && v[i] > bestV) {
                bestV = v[i];
                bestI = i;
            }
        }
        if (bestI == -1) cout << 0 << "\n\n";
        else cout << 1 << "\n" << bestI << "\n";
        return 0;
    }

    int S = (int)sumVp;
    const long long INF = (1LL<<62);

    // dp[s] = minimal weight to achieve scaled value s using processed items
    vector<long long> dp(S+1, INF);
    dp[0] = 0;

    // store decisions in compressed bitset:
    // take[i][s] = 1 if item i is taken when achieving dp after processing i at state s
    int blocks = (S + 64) / 64;
    uint64_t* take = new uint64_t[(long long)(N+1) * blocks];
    memset(take, 0, (long long)(N+1) * blocks * sizeof(uint64_t));

    for (int i = 1; i <= N; i++) {
        int add = vp[i];
        if (add == 0) {
            // no need to update dp indices (scaled value doesn't change),
            // but leaving it is OK; we just can't represent "taking it" in s-space.
            // Standard FPTAS guarantee still holds even if we ignore these in DP.
            continue;
        }
        for (int s = S; s >= add; s--) {
            if (dp[s - add] == INF) continue;
            long long cand = dp[s - add] + w[i];
            if (cand < dp[s]) {
                dp[s] = cand;
                set_bit(take, blocks, i, s); // mark that for state s we take item i
            }
        }
    }

    // best scaled value within weight W
    int bestS = 0;
    for (int s = 0; s <= S; s++) {
        if (dp[s] <= W) bestS = s;
    }

    // reconstruct by going backwards over items
    vector<int> chosen;
    int curS = bestS;
    long long curW = dp[bestS];

    for (int i = N; i >= 1; i--) {
        int add = vp[i];
        if (add == 0) continue;
        if (curS >= add && get_bit(take, blocks, i, curS)) {
            // verify feasibility w.r.t dp:
            // (This check makes reconstruction ultra-robust.)
            if (dp[curS - add] != INF && dp[curS - add] + w[i] == dp[curS]) {
                chosen.push_back(i);
                curS -= add;
            }
        }
    }

    sort(chosen.begin(), chosen.end());

    // final safety: ensure total weight <= W (should hold)
    long long totW = 0;
    for (int idx : chosen) totW += w[idx];
    if (totW > W) {
        // fallback: print empty (should practically never happen with checks above)
        cout << 0 << "\n\n";
    } else {
        cout << (int)chosen.size() << "\n";
        for (int i = 0; i < (int)chosen.size(); i++) {
            if (i) cout << " ";
            cout << chosen[i];
        }
        cout << "\n";
    }

    delete[] take;
    return 0;
}